/**********************************
 *							      *
 * ļ: 02 Ա            *
 * 							      *
 * ļ: StaticLinkedList.c     *
 * 				     		      *
 *   : 2.132.142.152.16 * 
 *                                *
 **********************************/

#ifndef STATICLINKEDLIST_C
#define STATICLINKEDLIST_C
 
#include "StaticLinkedList.h" 			//**02 Ա**//

/*TTTTT[
U 㷨2.14 U 
^TTTTT*/
void InitSpace_SL()						//ȳʼÿռ 
{
	int i;								//0ŵԪÿռʼ 

	for(i=0; i<MAXSIZE-1; i++)			//ռβ 
		SPACE[i].cur = i + 1;

	SPACE[MAXSIZE-1].cur = 0;	
}

/*TTTTT[
U 㷨2.15 U 
^TTTTT*/
int Malloc_SL()							//ӱÿռռ
{
	int i;
	
	i = SPACE[0].cur;					 

	if(SPACE[0].cur)				 
	{ 
		SPACE[0].cur = SPACE[i].cur;	//뵽Ŀռӱÿռɾȥ 
		return i;						//±
	}
	else
		return 0;						//ʧܷ0 
}

/*TTTTT[
U 㷨2.16 U 
^TTTTT*/
void Free_SL(int k) 					//kռ 
{
	SPACE[k].cur = SPACE[0].cur;		
	SPACE[0].cur = k;
}

Status InitList_SL(SLinkList *H)		//HΪͷָ 
{
	*H = Malloc_SL();					//ͷ 	
	if(!(*H))
		exit(OVERFLOW);					//ڴ桱 

	SPACE[*H].cur = 0; 					//ͷαΪ0 

	return OK;
}

Status ClearList_SL(SLinkList H)
{
	int p, q;
	
	if(!H)
		return ERROR;

	p = SPACE[H].cur;					//pָһ 
	
	while(p)							//׽㿪ʼɾ 
	{
		SPACE[H].cur = SPACE[p].cur;
		Free_SL(p);
		p = SPACE[H].cur;
	}

	return OK;
}

void DestroyList_SL(SLinkList *H)
{	
	ClearList_SL(*H);					//վ̬ 
	
	Free_SL(*H);							//ͷͷ	
	*H = 0; 
}

Status ListEmpty_SL(SLinkList H)
{
	if(H && !SPACE[H].cur)				//ֻͷ 
		return TRUE;
	else
		return FALSE;
} 

int ListLength_SL(SLinkList H)
{
	int count;							//
	int p;
	
	if(!H)
		exit(OVERFLOW);

	count = 0;
	p = SPACE[H].cur;
	
	while(p)
	{
		count++;
		p = SPACE[p].cur;
	}

	return count;
} 

Status GetElem_SL(SLinkList H, int i, LElemType_S *e)
{
	int count, p;
	
	if(!H || i<1 || i>MAXSIZE-2)
		return ERROR;
	
	count = 0;
	p = SPACE[H].cur;
	
	while(p)
	{
		count++;
		
		if(count==i)
		{
			*e = SPACE[p].data;		
			return OK;
		}

		p = SPACE[p].cur;
	}
} 

/*TTTTT[
U 㷨2.13 U 
^TTTTT*/
int LocateElem_SL(SLinkList H, LElemType_S e)
{
	int k, count;
	
	count = 1;
	if(H && SPACE[H].cur)
	{
		k = SPACE[H].cur;
		
		while(k && SPACE[k].data!=e)
		{
			count++;
			k = SPACE[k].cur;	
		}
		
		if(k)
			return count;
	}
	
	return 0;			
} 

Status PriorElem_SL(SLinkList H, LElemType_S cur_e, LElemType_S *pre_e)
{
	int p, q;

	if(H)
	{
		p = SPACE[H].cur;
		
		if(p && SPACE[p].data!=cur_e)
		{
			q = SPACE[p].cur;
			
			while(q && SPACE[q].data!=cur_e)
			{
				p = q;
				q= SPACE[q].cur;
			}
			
			if(q)								//ҵcur_e
			{
				*pre_e = SPACE[p].data;
				return OK;			
			}
		}
	}
	
	return ERROR;
} 

Status NextElem_SL(SLinkList H, LElemType_S cur_e, LElemType_S *next_e)
{
	int p;
	
	if(H)
	{
		p = SPACE[H].cur;
		
		while(p && SPACE[p].data!=cur_e)
			p = SPACE[p].cur;
		
		if(p && SPACE[p].cur)					//ҵcur_eҲһ 
		{
			p = SPACE[p].cur;
			*next_e = SPACE[p].data;
			return OK;
		}	
	}
	
	return ERROR;
} 

Status ListInsert_SL(SLinkList H, int i, LElemType_S e)
{
	int count, k, p;
	
	if(!H)								// 
		return ERROR;
	
	if(i>0)
	{
		count = 0;
		k = H;							//kָͷ 
		
		while(k && count<i-1)			//ѰҲλõǰһλ 
		{
			count++;
			k = SPACE[k].cur;
		}
		
		if(k)							//ҵ˵i-1Ԫصλ 
		{
			p = Malloc_SL();
			if(!p)						//ռʧ 
				return ERROR;

			SPACE[p].data = e;			//Ԫe 
			SPACE[p].cur = SPACE[k].cur;
			SPACE[k].cur = p;
			
			return OK;			
		}		
	}

	return ERROR;	
} 

Status ListDelete_SL(SLinkList H, int i, LElemType_S *e)
{
	int count, k, p;
	
	if(!H)								// 
		return ERROR;
	
	if(i>0)
	{
		count = 0;
		k = H;							//kָͷ 
		
		while(k && count<i-1)			//ѰҲλõǰһλ 
		{
			count++;
			k = SPACE[k].cur;
		}
		
		if(k && SPACE[k].cur)			//ҵ˵i-1ԪصλҲһԪ 
		{
			p = SPACE[k].cur;			//pָҪɾĽ 
			*e = SPACE[p].data;
			SPACE[k].cur = SPACE[p].cur;
			Free_SL(p);			

			return OK;			
		}		
	}

	return ERROR; 
} 

Status ListTraverse_SL(SLinkList H, void(Visit)(LElemType_S))
{
	int p;
	
	if(!H)
		return ERROR;					//̬ڻΪ
		
	p = SPACE[H].cur;
	
	while(p)
	{
		Visit(SPACE[p].data);
		p = SPACE[p].cur;
	}

	return OK;
}

#endif 
